definition module EnDecode;

import StdEnv;

import DefaultElem;

// non-unique, straight-forward conversions
class EnDecode a 
where {
	to_size	:: a -> !Int;
	to_string :: a !Int !*{#Char} -> (!Int,!*{#Char});
	from_string :: !Int !{#Char} -> (a,!Int);
	
	encode :: a -> !*{#Char} | EnDecode a;
	encode a :== snd (to_string a 0 (createArray (to_size a) '@'));

	decode :: !{#Char} -> a | EnDecode a;
	decode buffer :== fst (from_string 0 buffer)
		
};

instance EnDecode Bool;

instance EnDecode Int;

instance EnDecode Char;

/*2.0
instance EnDecode [b] | EnDecode, DefaultElem b &  Array {#} b;
0.2*/
//1.3
instance EnDecode [b] | EnDecode b;
//3.1

//1.3
instance EnDecode {#a} | EnDecode, DefaultElem, ArrayElem a;
//3.1
/*2.0
instance EnDecode {#a} | EnDecode, DefaultElem a & Array {#} a;
0.2*/

//1.3
instance EnDecode {b} | EnDecode b & DefaultElem b & ArrayElem b;
//3.1
/*2.0
instance EnDecode {a} | EnDecode, DefaultElem a & Array {} a;
0.2*/

/*2.0
instance EnDecode (a,b) | EnDecode a & EnDecode b;
0.2*/
//1.3
instance EnDecode (a,b) | EnDecode b & EnDecode a;
//3.1

/*2.0
instance EnDecode (a,b,c,d) | EnDecode a & EnDecode b & EnDecode c & EnDecode d;
0.2*/
//1.3
instance EnDecode (a,b,c,d) | EnDecode a & EnDecode b & EnDecode c & EnDecode d;

//3.1
/*2.0
instance EnDecode (a,b,c,d,e) | EnDecode a & EnDecode b & EnDecode c & EnDecode d & EnDecode e;
0.2*/
//1.3
instance EnDecode (a,b,c,d,e) | EnDecode a & EnDecode b & EnDecode c & EnDecode d & EnDecode e;
//3.1
